function []=prtscrf1(skt,n,delay)
%function []=prtscrf(skt,n,delay)
% Print pic screen from skt to current figure n times
% updated for octave 3-Feb-2018 - Ian Stothers
if ischar(skt)
  skt=sktopen(skt);
end
scr = char(udpget(skt,'Screen')');
%try
    a=figure ("toolbar", "none");
    set(a,'renderermode','manual');
    set(a,"numbertitle","off");
    set(a,'name',['Printscreen IP - ' skt.ip]);

   if (nargin<2) n=0; end
   if (nargin<3) delay=0.25; end
   clf;
   tl=0:255;
   tl(1:32)=ones(32,1)*' ';
   tl(95)=' ';
   tl(96)='-';
   tl(126:256)=ones(131,1)*' ';
   scr=char(tl(scr+1));
   ss=size(scr);
   axis([0 ss(2) -ss(1) 0]);
   axis('off') ;

   a=text(0,-ss(1)/2,scr);
   set(a,'fontname','courier new');
   set(a,'fontsize',14);

    while n~=1
      scr=char(tl(udpget(skt,'Screen')'+1));
      set(a,'string',scr);
      drawnow();
      pause(delay);
      n=n-1;
    end
%catch
 %close(a);
%end
endfunction
